/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.items.builders;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.impactdev.impactor.api.items.ImpactorItemStack;
import net.impactdev.impactor.api.items.builders.ImpactorItemStackBuilder;
import net.impactdev.impactor.api.items.properties.MetaFlag;
import net.impactdev.impactor.api.items.properties.enchantments.Enchantment;
import net.impactdev.impactor.api.items.properties.enchantments.Enchantments;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractStackBuilder<I extends ImpactorItemStack, B extends ImpactorItemStackBuilder<I, B>>
implements ImpactorItemStackBuilder<I, B> {
    public Component title;
    public List<Component> lore = Lists.newArrayList();
    public int quantity = 1;
    public Set<Enchantment> enchantments = Sets.newLinkedHashSet();
    public Set<MetaFlag> flags = Sets.newHashSet();
    public int durability;
    public boolean unbreakable;
    @Nullable
    public Integer customModelData = null;
    public CompoundBinaryTag nbt;

    @Override
    public B quantity(int quantity) {
        this.quantity = quantity;
        return (B)this;
    }

    @Override
    public B title(Component title) {
        this.title = title;
        return (B)this;
    }

    @Override
    public B lore(Component ... lore) {
        this.lore.addAll(Arrays.asList(lore));
        return (B)this;
    }

    @Override
    public B lore(Collection<Component> lore) {
        this.lore.addAll(lore);
        return (B)this;
    }

    @Override
    public B enchantment(Enchantment enchantment) {
        this.enchantments.add(enchantment);
        return (B)this;
    }

    @Override
    public B durability(int durability) {
        this.durability = durability;
        return (B)this;
    }

    @Override
    public B unbreakable(boolean state) {
        this.unbreakable = state;
        return (B)this;
    }

    @Override
    public B hide(MetaFlag ... flags) {
        this.flags.addAll(Arrays.asList(flags));
        return (B)this;
    }

    @Override
    public B hide(Collection<MetaFlag> flags) {
        this.flags.addAll(flags);
        return (B)this;
    }

    @Override
    public B glow() {
        this.enchantment(Enchantment.create(Enchantments.UNBREAKING, 1));
        this.hide(MetaFlag.ENCHANTMENTS);
        return (B)this;
    }

    @Override
    public B customModelData(int value) {
        this.customModelData = value;
        return (B)this;
    }

    @Override
    public B nbt(CompoundBinaryTag nbt) {
        this.nbt = nbt;
        return (B)this;
    }
}

